/*
	
	Sugg: Detect if on desktop computer, only available if you got a big screen !?
	Answer: Some mobiles support split screen, then it could be useful.
	
*/

(function() {
	"use strict";
	
	var windowMenuNewWindow, windowMenuSplitScreen;
	var discoveryBarIcon;
	
	EDITOR.plugin({
		desc: "Open file in new window",
		load: function loadFloatingWindow() {
			
			EDITOR.on("ctxMenu", openInNewWindowCtxmenuOption);
			
			windowMenuNewWindow = EDITOR.windowMenu.add(S("open_in_new_window"), [S("File"), 9], openInNewWindow);
			windowMenuSplitScreen = EDITOR.windowMenu.add(S("split_screen_new_window"), [S("View"), 50], splitScreen);
			
			//discoveryBarIcon = EDITOR.discoveryBar.addIcon("gfx/new-window.svg", 130, S("open_in_new_window"), "+win", openWindowFromMenu);
			// Icon created by: https://www.flaticon.com/authors/phatplus
			
		},
		unload: function unloadFloatingWindow() {
			EDITOR.windowMenu.remove(windowMenuNewWindow);
			EDITOR.windowMenu.remove(windowMenuSplitScreen);
			if(discoveryBarIcon) EDITOR.discoveryBar.remove(discoveryBarIcon);
			EDITOR.removeEvent("ctxMenu", openInNewWindowCtxmenuOption);
		},
		order: 6000 // Want option to appear low in the context menu
	});
	
	function openInNewWindowCtxmenuOption(file, combo, caret, target) {
		if(target.className=="fileCanvas" && file) {
			var filePath = file.path;
		}
		else if(target.getAttribute("path")) {
			var filePath = target.getAttribute("path");
		}
		
		if(!filePath) return;
		
		EDITOR.ctxMenu.addTemp(S("open_in_new_window"), openInNewWindowFromCtxmenu);
		
		function openInNewWindowFromCtxmenu() {
			openInNewWindow(filePath);
		}
	}
	
	function openWindowFromMenu() {
		openInNewWindow(EDITOR.currentFile);
	}
	
	function splitScreen() {
		
		// todo: Test with multiple screens, and windows managers (such as i3)
		
		var browserWindowWidth = window.outerWidth;
		var browserWindowHeight = window.outerHeight;
		var browserWindowPositionX = window.screenX || window.screenLeft;
		var browserWindowPositionY = window.screenY || window.screenTop;
		
		var screenWidth = screen.width;
		var screenHeight = screen.height;
		
		var editorCodeWindow = window;
		
		var width1 = Math.floor(browserWindowWidth / 2);
		var width2 = width1*2 == browserWindowWidth ? width1 : width1+1;
		
		var height = browserWindowHeight;
		var browserChromeHeight = 30;
		
		var isAtMaxWidth = screen.availWidth - window.innerWidth === 0; // Seems we can't resize a window that is maximized'
		
		console.log("splitScreen: browserWindowWidth=" + browserWindowWidth + " browserWindowHeight=" + browserWindowHeight + " isAtMaxWidth=" + isAtMaxWidth);
		console.log("splitScreen: screenWidth=" + screenWidth + " screenHeight=" + screenHeight);
		console.log("splitScreen: browserWindowPositionX=" + browserWindowPositionX + " browserWindowPositionY=" + browserWindowPositionY);
		console.log("splitScreen: width1=" + width1 + " width2=" + width2 + " height=" + height);
		
		//editorCodeWindow.moveTo(0, 0);
		editorCodeWindow.resizeTo(width1, height);
		EDITOR.resizeNeeded();
		
		var options = {
			top: browserWindowPositionY-browserChromeHeight,
			left: browserWindowPositionX+width1,
			width: width2,
			height: height
		}
		
		openInNewWindow(EDITOR.currentFile, options, function windowOpened(err, win) {
			
			//win.resizeTo(width2, height);
			//win.moveTo(options.left, options.top);
			
			windowMenuSplitScreen.hide();
			
			EDITOR.stat("split_screen");
		}); 
		
		// canvas freezes when the other window is closed !?
		
	}
	
	function openInNewWindow(filePath, browserWindowOptions, callback) {
		
		if(typeof browserWindowOptions == "function" && callback == undefined) {
			callback = browserWindowOptions;
			browserWindowOptions = {};
		}
		
		if(typeof browserWindowOptions != "object") {
			browserWindowOptions = {};
		}
		
		if(filePath.hasOwnProperty("path")) {
			filePath = filePath.path;
		}
		
		if(EDITOR.files.hasOwnProperty(filePath)) {
			var file = EDITOR.files[filePath];
			
			if(!file.hasOwnProperty("text")) {
				var msg = "Can currently only open text files in new window!";
				if(callback) callback(new Error(msg));
				else alertBox(msg);
				return;
			}
			
			var text = file.text;
			var openFileOptions = {isSaved: file.isSaved, savedAs: file.savedAs, changed: file.changed};
			var line = file.caret.row + file.partStartRow + 1;
			
		}
		
		
		
		EDITOR.ctxMenu.hide();
		windowMenuNewWindow.hide();
		
		if(!browserWindowOptions.url) browserWindowOptions.url = "/?disable=collaboration_notice,reopen_files,trmb,file_tabs,discoveryBar,dashboard";
		if(!browserWindowOptions.waitUntilLoaded) browserWindowOptions.waitUntilLoaded = true;
		
		if(QUERY_STRING["theme"]) browserWindowOptions.url += "&theme=" + QUERY_STRING["theme"];
		
		var thisEditor = window.EDITOR;
		
		EDITOR.createWindow(browserWindowOptions, function windowOpened(err, browserWindow) {
			if(err) throw err;
			
			// Load the file in the other window
			console.log("openInNewWindow: browserWindow.window=", browserWindow.window);
			var otherEditor = browserWindow.window.EDITOR;
			
			// Wait until logged in
			otherEditor.on("storageReady", function openFileOnceConnected() {
				
				otherEditor.openFile(filePath, text, openFileOptions, function(err, fileInOtherWindow) {
				if(err) throw err;
				
					if(line) fileInOtherWindow.gotoLine(line);
				
				otherEditor.on("fileClose", function fileClosed(closedFile) {
					var openedFiles = Object.keys(otherEditor.files);
					if(openedFiles.length == 1) {
						browserWindow.close();
						setTimeout(browserWindowClosed, 100);
					}
				});
				
				
				var checkOpenInterval = setInterval(checkIfOpen, 1);
				/*
					Callbacks from the other window will refer to the other window!??!?
					So we can't actually have any code here, as that code wont run here !?!?
				*/
				
				
				// Hide "collaborator leaved" message when window is closed ...
				var checkCloseInterval = setInterval(checkIfClosed, 1000);
				
				setTimeout(function() {
					// This callback function seem to run in this window context though !?!?
					browserWindow.window.onbeforeunload = function() {
						clearInterval(checkCloseInterval);
						checkCloseInterval = setInterval(checkIfClosed, 1);
						return undefined; // Will not warn about unsaved changes
					}
				}, 1000);
				
				if(typeof callback == "function") callback(null, browserWindow);
				
				EDITOR.stat("floating_window");
				
				function checkIfClosed() {
					if(!browserWindow || browserWindow.closed) {
						browserWindowClosed();
					}
				}
				
				function checkIfOpen() {
					if(browserWindow && browserWindow.window.EDITOR) {
						clearInterval(checkOpenInterval);
						closeCollabDialogs();
					}
					//else console.log("File in other window not yet opened ... browserWindow? " + !!browserWindow + " browserWindow.window.EDITOR? " + !!browserWindow.window.EDITOR + " thisEditor.openDialogs.length=" + thisEditor.openDialogs.length + " ");
				}
				
				function browserWindowClosed() {
					clearInterval(checkCloseInterval);
					
					closeCollabDialogs();
					}
				
				
			});
			});
			
			function closeCollabDialogs() {
				// Close dialog about collaboratior leaving
				
				var dialogCodes = EDITOR.openDialogs.map(function(dialog) { return dialog.code });
				if(dialogCodes.indexOf("COLLABORATION_NOTICE") != -1) EDITOR.closeAllDialogs("COLLABORATION_NOTICE");
				
				// Sometimes the dialog comes up late ...
				setTimeout(closeCollabDialogs, 50);
			}
			
		});
	}
	
	
})();
