(function() {
	
	"use strict";
	
	var order = 99;
	
	EDITOR.on("autoComplete", autoCompleteJsMisc, order);
	
	
	function autoCompleteJsMisc(file, word, wordLength, gotOptions) {
		
		if(wordLength === 0) return;
		if(gotOptions > 0) return; // Prefer other options like variables and functions
		
		var options = [];
		
		var lbLength = file.lineBreak.length;
		
			if("function".substr(0, wordLength) == word) {
			options.push(["function () {" + file.lineBreak + file.lineBreak + "}", 7]);
		}
		else if("for".substr(0, wordLength) == word) {
			options.push(["for (var i=0; i<.length; i++) {" + file.lineBreak + file.lineBreak + "}", 18]);
		}
		else if("switch".substr(0, wordLength) == word) {
			options.push(["switch() {" + file.lineBreak + "case :    ; break" + file.lineBreak + "}", 23]);
		}
		else if("if".substr(0, wordLength) == word) {
			options.push(["if () {" + file.lineBreak + file.lineBreak + "}", 6]);
		}
		
		return options;
	}
	
	
})();
