
(function() {
	
	"use strict";

	EDITOR.plugin({
		desc: "Goto line",
		load: gotoLine_load,
		unload: gotoLine_unload
	});
	
	var gotoDiv;
	var footer;
	var gotoInputIsVisible = false;
	var inputGoto;
	var gotoButton;
	var key_Esc = 27;
	var key_G = 71;
	var key_J = 74;
	var RE_SUB;
	
	var winMenuGotoLine;
	
	//window.addEventListener("load", goto_init, false);

	function gotoLine_load() {
		
		// Create markup
		footer = document.getElementById("footer");
		gotoDiv = document.getElementById("goto");
		inputGoto = document.getElementById("inputGoto");
		gotoButton = document.getElementById("buttonGoto");
		
		// Sanity check
		if(!footer) {
			throw new Error("Can not find the footer!");
		}
		
		
		// Create the hypertext markup if it doesn't exist
		
		//build_gotoInput();
		
		hide_gotoLineInput();
		
		EDITOR.bindKey({desc: S("goto_line"), charCode: key_G, combo: CTRL, fun: gotoLineFromKeyboardComboG}); // ctrl + G
		EDITOR.bindKey({desc: S("goto_line"), charCode: key_J, combo: CTRL, fun: show_gotoInputEmacs}); // ctrl + J (Emacs)
		if(MAC) EDITOR.bindKey({desc: S("goto_line"), charCode: key_G, combo: META, fun: mac_gotoLine});
		
		EDITOR.bindKey({desc: S("hide_goto_line_widget"), charCode: key_Esc, fun: hide_gotoLineInput});
		
		var voiceRegexp = /((go ?to)|(jump( ?to)?))?( ?line)? (\d*)/i;
		
		RE_SUB = 6;
		
		UTIL.regexpAssert(voiceRegexp, [
		"goto line 100", 
		"go to line 100", 
			"jump to line 100",
			"jump 100",
		"goto 100", 
			"jump to 100"
		], RE_SUB, "100");
		
		EDITOR.addEvent("voiceCommand", {
			re: voiceRegexp, 
			grammar: ["(goto|go to|jump to) line|jump to|jump) <numbers>", "line <numbers>"], fun: gotoLineVoice
		});
		
		winMenuGotoLine = EDITOR.windowMenu.add(S("goto_line"), [S("Navigate"), 11], gotoLineFromWindowMenu, gotoLineFromKeyboardComboG);
		
		EDITOR.registerAltKey({char: "g", alt:1, label: S("goto"), fun: gotoLineFromVirtualKeyboard});
		
		}
	
	function gotoLine_unload() {
		
		EDITOR.unbindKey(gotoLineFromKeyboardComboG);
		EDITOR.unbindKey(show_gotoInputEmacs);
		
		EDITOR.unbindKey(hide_gotoLineInput);
		
		EDITOR.removeEvent("voiceCommand", gotoLineVoice);
		
		EDITOR.windowMenu.remove(winMenuGotoLine);
		
		EDITOR.unregisterAltKey(gotoLineFromVirtualKeyboard);
		
	}
	
	function gotoLineVoice(text, file, match) {
		
		console.log(match);
		
		var line = parseInt(match[RE_SUB]);
		
		if(isNaN(line)) {
console.warn("line=" + line + " is not a number! match=" + JSON.stringify(match) + " RE_SUB=" + RE_SUB); 
			return false; // Did not capture it
		}
		
		EDITOR.stat("goto_line_voice");
		
		if(file) {
file.gotoLine(line);
			return true; // Captured!
		}
		else return false; // Did not capture it
	}
	
	function build_gotoInput() {
		
		gotoDiv = document.createElement("div");
		gotoDiv.setAttribute("id", "gotoDiv");
		gotoDiv.setAttribute("class", "gotoDiv");
	
		inputGoto = document.createElement("input");
		inputGoto.setAttribute("type", "text");
		inputGoto.setAttribute("id", "inputGoto");
		inputGoto.setAttribute("class", "inputtext");
		inputGoto.title = "line:column";

		var labelGoto = document.createElement("label");
		labelGoto.setAttribute("for", "inputGoto");
		labelGoto.appendChild(document.createTextNode("Goto line:")); // Language settings!?

		gotoButton = document.createElement("input");
		gotoButton.setAttribute("type", "button");
		gotoButton.setAttribute("class", "button");
		gotoButton.setAttribute("id", "gotoButton");
		gotoButton.setAttribute("value", "Go!");

		var cancelButton = document.createElement("input");
		cancelButton.setAttribute("type", "button");
		cancelButton.setAttribute("class", "button");
		cancelButton.setAttribute("id", "cancelButton");
		cancelButton.setAttribute("value", "cancel");

		
		gotoDiv.appendChild(labelGoto);
		gotoDiv.appendChild(inputGoto);
		gotoDiv.appendChild(gotoButton);
		gotoDiv.appendChild(cancelButton);
		
		footer.appendChild(gotoDiv);
	
	
		inputGoto.addEventListener("keyup", function(keyUpEvent) {
			keyUpEvent.preventDefault();
			if (keyUpEvent.keyCode == 13) {
				gotoLine(); // When pressing enter
			}
			else if(keyUpEvent.keyCode == key_Esc) {
				hide_gotoLineInput(); // When pressing escape
			}
		});
	
		gotoButton.addEventListener("click", gotoLine, false);
		
		cancelButton.addEventListener("click", hide_gotoLineInput, false);
		
		gotoInputIsVisible = true;
		
		console.log("built gotoInput!");

	}
	
	function gotoLineFromWindowMenu(file, combo) {
		EDITOR.stat("gotoLineFromWindowMenu");
		return show_gotoInput(file, combo);
	}
	
	function gotoLineFromVirtualKeyboard(file, combo) {
		EDITOR.stat("gotoLineFromVirtualKeyboard");
		return show_gotoInput(file, combo);
	}
	
	function gotoLineFromKeyboardComboG(file, combo) {
		EDITOR.stat("gotoLineFromKeyboardComboG");
		return show_gotoInput(file, combo);
	}

function mac_gotoLine(file, combo) {
EDITOR.stat("mac_gotoLine");
return show_gotoInput(file, combo);
}
	
	function show_gotoInputEmacs(file, combo) {
		EDITOR.stat("gotoLineFromKeyboardComboJ");
		return show_gotoInput(file, combo);
	}
	
	function show_gotoInput(file, combo) {
		console.log("gotoInputIsVisible=" + gotoInputIsVisible + " before showing");

		winMenuGotoLine.hide();
		
		if(!gotoInputIsVisible) {
			
			console.log("gotoDiv=" + gotoDiv);
			
			if(gotoDiv) console.log("gotoDiv.style.dipslay=" + gotoDiv.style.dipslay);
			
			//if(!gotoDiv) build_gotoInput();
			build_gotoInput(); // Always build!
			
			var footerHeight = parseInt(footer.style.height);
			var heightNeeded = 45;
			
			gotoDiv.style.display="block";
			
			/* We need the footer to be this high
			if(footerHeight < heightNeeded) {
				//footer.style.height = footerHeight + heightNeeded + "px";
				EDITOR.resizeNeeded();
			}
			*/
			
			gotoInputIsVisible = true;
			
			EDITOR.resizeNeeded();
			EDITOR.renderNeeded();
			
		}

		// Remove focus from the editor
		if(EDITOR.currentFile) {
			EDITOR.input = false;
		}

		inputGoto.focus();   // Add focus to the input
		inputGoto.select();  // Select all
				
		return false; // Function must return false to ignore default browser action!

	}

	function hide_gotoLineInput() {
		
		console.log("gotoInputIsVisible=" + gotoInputIsVisible + " before hiding");
		
		if(gotoInputIsVisible) {
			
			// Hide the search window
			//gotoDiv.style.display="none"; // Need to hide this, or the footer will not scrimp
			
			gotoDiv.parentNode.removeChild(gotoDiv);
			
			//footer.style.height = "0px"; // Hmm, can't be less then one px
			
			// Bring back focus to the current file
			if(EDITOR.currentFile) {
				EDITOR.input = true;
			}
			
			gotoInputIsVisible = false;
			
			EDITOR.resizeNeeded();
			EDITOR.renderNeeded();
			
			return false;
		}
		
		return true;
	}

	
	function gotoLine(line) {
		
		if(gotoInputIsVisible) {
			
			var lineStr = inputGoto.value;
			if(lineStr.indexOf(":") > 0) {
				var lineCol = lineStr.split(":");
				var line = parseInt(lineCol[0]);
				var col = parseInt(lineCol[1]);
			}
			else {
				var line = parseInt(inputGoto.value);
			}
			
			var file = EDITOR.currentFile;
			
			if(!file) throw new Error("No current file!");
			
			if(isNaN(line)) {
				alertBox("Enter line number!");
			}
			else if(!file) {
				alertBox("No file open!");
			}
			else {
				
				if(line < 1) line = 1;
				
				console.log("file.totalRows=" + file.totalRows);
				
				var maxLine = Math.max(file.grid.length, (file.totalRows+1));
				
				if(line > maxLine) line = maxLine;
				
				console.log("Going to line " + line + ".");
				
				file.gotoLine(line, function(err) {
					if(err) return alertBox("Unable to go to line " + line + " Error: " + err.message);
					else if(col) {
						file.moveCaret(undefined, file.caret.row, col);
						var lookAhead = Math.floor(EDITOR.view.visibleColumns/2);
						file.scrollToCaret(file.caret, lookAhead);
					}
					
				});
				
				
				
				hide_gotoLineInput();
				
			}
		
			return false; // Return false to prevent default (typing a linebreak character)

		}
		
		return true;
	}
	
})();