
(function() {
	/*
	EDITOR.plugin({
		desc: "Render the text's background color",
		load: function loadTextBgRenderl() {
			
			// We want this render function to run before text rendering
			// But after renders that clears the background!
			EDITOR.addRender(textBgRender, 1900);
			
			console.log("Loaded textbg renderer");
			},
		unload: function unloadTextBgRenderl() {
			EDITOR.removeRender(textBgRender);
			console.log("Unloaded textbg renderer");
		},
		order: 1 // Make sure it runs before text render so that the text is rendered above (and not under) the background
	});
	
	*/
	
	EDITOR.addRender(textBgRender, 1900);
	
	function textBgRender(ctx, buffer, file, startRow) {
		"use strict";

		//console.time("textBgRender");
		
		if(startRow == undefined) startRow = 0;
		
		//console.log(JSON.stringify(buffer, null, 2));
		
		//ctx.beginPath(); // Reset all the paths!
		
		var left = 0;
			var top = 0;
			var indentation = 0;
		var indentationWidth = 0;
			var file = EDITOR.currentFile;
		var oldBgColor = null;
		var chars = 0;
		var width = 0;
		var walker;

		ctx.fillStyle=EDITOR.settings.style.highlightTextBg;
	
		for(var row = 0; row < buffer.length; row++) {
			
			indentation = buffer[row].indentation;
			indentationWidth = indentation * EDITOR.settings.tabSpace;
			top = EDITOR.settings.topMargin + (row + startRow) * EDITOR.settings.gridHeight;
			left = EDITOR.settings.leftMargin + Math.max(0, indentationWidth - file.startColumn) * EDITOR.settings.gridWidth;
			
			oldBgColor = null;
			chars = 0;
			
			walker = EDITOR.gridWalker(buffer[row]);


			while(!walker.done) {
				walker.next();

				//console.log("textBgRender: walker.col=" + walker.col + " chars=" + chars);
				if(buffer[row][walker.col].bgColor != oldBgColor) {
					if(oldBgColor) {
						
						width = EDITOR.settings.gridWidth * chars;
						
						ctx.fillStyle = oldBgColor;
						ctx.fillRect(left, top,	width, EDITOR.settings.gridHeight);
						//console.log("oldBgColor=" + oldBgColor + " chars=" + chars + " row=" + row + " col=" + col + " left=" + left + " top=" + top + " width=" + width);
						
					}
					
					left += chars * EDITOR.settings.gridWidth;
					oldBgColor = buffer[row][walker.col].bgColor;
					chars = 0;
				}
				
				chars += walker.charWidth;
				
			}
			//console.log("yyy row=" + row);
			
			// For the last bgcolor
			if(oldBgColor) {
				width = EDITOR.settings.gridWidth * chars;
				ctx.fillStyle = oldBgColor;
				ctx.fillRect(left, top,	width, EDITOR.settings.gridHeight);
				//console.log("oldBgColor=" + oldBgColor + " chars=" + chars + " row=" + row + " col=" + col + " left=" + left + " top=" + top + " width=" + width + " EOL!");
			}
		}
		
		//ctx.stroke();
		//console.timeEnd("textBgRender");

	}

})();
