/*
	
	Note the callback can only have two arguments: Error and Response,
	multiple arguments need to be put into an object! eg: foo(  (a, b, c) => callback(null, {a,b,c})  )
	
	
	
*/


try {
var module_mysql = require("mysql2");
}
catch(err) {
	console.log("MYSQL: " + err.message);
}

var module_os = require("os");
var module_fs = require("fs");
var currentDb = "information_schema";
var connection;
var connectionError = false;

try {
	var info = module_os.userInfo ? module_os.userInfo() : {username: "ROOT", uid: process.geteuid()};
}
catch(err) {
}

var env = process.env;

if(!module_mysql) {
	var MYSQL = {
		query: moduleDoesntExist,
		databases: moduleDoesntExist
	}
}
else {
	
	var MYSQL = {
		query: function mysqlQuery(user, json, callback) {
		
		var dbName = json.database;
		
		if(dbName == undefined) return callback(new Error("No database specified!"));
		
			connectIfNotConnectedAndUseDatabase(user.name, dbName, function runQuery(err) {
			if(err) return callback(err);
			
			connection.query(json.query, function(err, results, fields) {
				if(err) {
					console.log("MYSQL: query failed: " + json.query + "\nError: " + err.message);
					return callback(err);
				}
				else {
					callback(null, {results: results, fields: fields});
				}
			});
		});
	},
		connect: function mysqlConnect(user, json, callback) {
			// Connects to a database
			
			connect(json.username, json.password, json.hostname, json.database, callback);
			
		},
		disconnect: function mysqlDisconnect(user, json, callback) {
			if(connection && !connection._fatalError) {
				// It seems connection.end never calls back if there is a problem ...
				connection.end(function(err) {
					console.log("MYSQL: MySQL connection ended!");
					if(err) console.error(err);
					
					callback(null);
				});
			}
			else {
				console.log("MYSQL: Not connected!");
				callback(null);
			}
		}
	}
}

function connectIfNotConnectedAndUseDatabase(editorUsername, database, callback) {
	
	if(!connection || connection.state === 'disconnected' || connection._fatalError || connectionError) {
		if(!lastPassword) {
			// Connect to local server
			connect(editorUsername, undefined, undefined, database, callback);
		}
		else {
			connect(lastUsername, lastPassword, lastHostname, database, callback);
		}
	}
	else if(database != lastDatabase) {
		console.log("MYSQL:Switching to database=" + database);
		connection.query("USE `" + database + "`", function(err) {
			if(!err) lastDatabase = database;
			
			callback(err);
		});
	}
	else {
		callback(null);
	}
	
}

var lastUsername, lastPassword, lastHostname, lastDatabase;

function connect(username, password, hostname, database, callback) {
	
	if(arguments.length != 5) throw new Error("Need 5 arguments!");
	
	lastUsername = username;
	lastPassword = password;
	lastHostname = hostname;
	lastDatabase = database;
	
	if(hostname) {
		var connectionOptions = {
			user: username,
			password: password,
			host: hostname,
			database: database || "information_schema"
		};
		
		makeConnection(connectionOptions);
	}
	else {
		// Connect to local database
		var socket = "/var/run/mysqld/mysqld.sock";
		
		module_fs.stat(socket, function(err, stats) {
			if(err && err.code == "ENOENT") return callback(new Error("Can not find " + socket + ". MySQL is probably not installed or configured on this server. See mySQL section in README.txt for more info."));
			else if(err) throw err;
			
			console.log(JSON.stringify(stats, null, 2));
			
			console.log("MYSQL: stats.isSocket()=" + stats.isSocket());
			
			var connectionOptions = {
				user: username,
				socketPath: socket,
				authSwitchHandler: true, // Need to be true:ish
				database: database || "information_schema"
			};

			makeConnection(connectionOptions);
			
		});
		return;
	}
	
	function makeConnection(connectionOptions) {
		
		//console.log(JSON.stringify(connection, null, 2));
	
	//if(connection && database == currentDb && !connection._closing) return callback(null);
	
		connection = module_mysql.createConnection(connectionOptions);
		
		var processUser = env.SUDO_USER || env.LOGNAME || env.USER || env.LNAME || env.USERNAME || info.username;
		
		console.log("MYSQL: connect: Connecting to mySQL database=" + database + " with username " + username + " running as " + processUser);
		
		currentDb = database;
		
		//connection.connect(callback);
		
		connection.connect(function(err) {
			if(err) {
				console.error(err);
				callback(err);
			}
			else {
				console.log("MYSQL: Connected to mysql database=" + database + "");
				connectionError = false;
				connection.on('error', function(err) {
					console.log("MYSQL error: (code=" + err.code + ") " + err.message);
					connectionError = true;
				});
				
				callback(null);
			}
		});
		
	}
	
}

function moduleDoesntExist(user, json, callback) {
	var error = new Error("mysql2 module is not installed on the server!");
	error.code = "MODULE_MISSING";
	callback(error);
}


module.exports = MYSQL;



